# AT Command Description
---

This article will describe in detail the grammatical format, function and use of each AT command. If not specified, an command  only applies to Wi-Fi mode.

All command are **effective immediately** without special command to save, **AT command** can be input through serial debugging programs such as super terminals, or through programming.


## Catalogue

1. [AT command format](#_at_command_format)
2. [EVENT format](#_event%20format)
3. [Basic AT Command](#_basicatCommand)
  1. [System AT Command](#1systematCommand)
  2. [UART Management Command](#_2uartManagementCommand)
  3. [Wi-Fi Management Command](#_3wifiManagementCommand)
  4. [TCP and UDP communication command](#_4tcpandUDPcommunicationcommand)
  5. [MQTT communication command](#5mqttcommunicationcommand)
  6. [Distribution Network Management Command](#6DistributionNetworkManagementCommand)
  7. [SNTP Time Synchronization command ](#_7sntpTimeSynchronizationcommand )
  8. [BT Control command ](#8btControlcommand )
  9. [Ethernet Pass-through Command](#9EthernetPass-throughCommand)**(only support moc108)**
  10. [Firmware OTA Command](#10FirmwareOTACommand)
4. [EVENT Notification](#EventNotification)



## AT command format
`AT+` command  adopts the command line based on ASCII code in the following format:

### 1. Format description

* a) <>: Represents the parts that must be included
* b) []: Represents the optional part


### 2. Command format
`AT+<CMD>[op][para-1, para-2, para-3,...]\r`

* a) `AT+: `Command message prefix
* b) `CMD:` command  string
* c) `[op]: `command  operator. It can be:
    * 1. `"=": `Represents parameter settings, or queries for specified parameters
    * 2. `"?": `Represents query system parameters
    * 3. `None': `Indicates the execution of command
    * 4. `"=?"`: Indicates the parameters set by the query user
* d) `[para-n]: `Represents the set parameter value or the specified query parameter
* e) `r`: Entry terminator, ASCII code 0x0D


### 3. Response message format

`[\r\n][+CMD:] [para-1, para-2, para-3,...] <\r\n> <STATUS> <\r\n>`

* a) `r:` Entry terminator, ASCII code: 0x0D
* b) ` n `: newline character, ASCII code: 0x0a
* c) `[+CMD:] `Corresponding command string
* d) `[para-n] `: Parameters returned at query time
* e) `[STATUS] `There are two cases of successful execution of command:
    * (1) `OK`: means correct execution;
    * (2) `ERROR`: Represents an execution error. 

## EVENT format

[EVENT message](#eventmessage) describes the current Wi-Fi/BT function and network connection status, such as STA, AP connection status, TCP, UDP connection status, RFCOMM connection status, etc.


Event message format: `\r\n+<TYPE>：[para-1,para-2,para-2,...,para-n]\r\n`

* ` <TYPE>`: Event types include `WEVENT`, which means WiFi function notification, `CIPEVENT`, which means network connection notification, and `BTEVENT', which means connection notification of BT/RFCOMM (only supported by EMW3239).
* `[para-n]`: Event parameters, see [EVENT Event Message] (# Event Event Message)
* `\r`: carriage return, ASCII code 0x0D
* `\n`: Line break, ASCII code 0x0a


## Basic AT Command
AT command  v2.0 mainly includes:

1. [System AT Command](#1systematCommand)
2. [UART Management Command](#2uartmanagementCommand)
3. [Wi-Fi Management Command](#3wifiManagementCommand)
4. [TCP/UDP Communication command](#4TCP/UDPCommunicationcommand)
5. [MQTT communication command](5mqttcommunicationcommand)
6. [Distribution Network Management Command](#6DistributionNetworkManagementCommand)
7. [SNTP Time Synchronization command ](7sntpTimeSynchronizationcommand )
8. [BT Control command ](8btControlcommand )


## 1.System AT Command

## 1. List of system AT command
|Order |Command |Description |
|:---: |:--- |:--- |
|1 |[AT+FWVER](#atfwver)|Query firmware version number|
|2 |[AT+SYSTIME](#atsystime)|Query system runtime |
|3 |[AT+MEMFREE](#atmemfree)|Query system remaining space size|
|4 |[AT+FACTORY](#atfactory)|Restore Module Factory Settings|
|5 |[AT+REBOOT](#atreboot) |Restart Module|
|6 |[AT+FLASHLOCK](#atflashlock)|Turn FLASH lock on or off|
|7 |[AT+WEVENT](#atwevent) |Turn on or turn off event message notifications prefixed with +WEVENT|
|8 |[AT+CIPEVENT](#atcipevent) |Turn on or turn off event message notifications prefixed with +CIPEVENT|
|9 |[AT+STANDBY](#atstandby) |Entering sleep mode |


### AT+FWVER
Function: Query firmware version number.

|Command:|`AT+FWVER?`|
|:---|:---|
|Response: |`+FWVER:<fwver>`|
|Parameter: |`fwver`: Firmware version number|


### AT+SYSTIME
Function: Query the running time of the system.

| Command: |`AT+SYSTIME?`|
|:---|:---|
| Response: |`+SYSTIME:<systime>`|
||`OK`|
| Parameter: |`systime`: System run time, in milliseconds (ms)|


### AT+MEMFREE
Function: Query the size of the system's remaining space.

| Command: |`AT+MEMFREE?`|
|:---|:---|
| Response: |`+MEMFREE:<storage>`|
||` OK`|
| Parameter: |`storage`: Storage space size, in bytes (Byte)|


### AT+FACTORY
Function: Restore [module factory settings](/ New_AT_command/3.New_AT_factory_set.md).

| Command: |`AT+FACTORY`|
|:---|:---|
| Response: |`OK`|
| Parameter: | None|
| Note: | Restart immediately and take effect|


### AT+REBOOT
Function: Restart module.

| Command: |`AT+REBOOT`|
|:---|:---|
| Response: |`OK`|
| Parameter: | None|


### AT+FLASHLOCK
Function: FLASH Lock command 

| Query command : |`AT+FLASHLOCK?`|
|:---|:---|
| Response: | `+FLASHLOCK:<mode>`|
||`OK`|
| Parameter: | Refer to Setting command  Parameters|


| Setting command: |`AT+FLASHLOCK=<mode>`|
|:---|:---|
| Response: |`OK`|
| Parameters: | `mode`:`ON`: Open; `OFF ` Close; After starting `FLASHLOCK', parameters will no longer be saved.|



### AT+WEVENT
Function: Open or close event message notification prefixed with + WEVENT.

| Query command : |`AT+WEVENT?`|
|:---|:---|
| Response: | `+WEVENT=<state>`|
||`OK`|
| Parameter: | Refer to Setting command  Parameters|

| Setting command: |`AT+WEVENT=<state>`|
|:---|:---|
| Response: |`OK`|
| Parameters: | `state `: `ON`, indicating that the notification function is turned on and `OFF`, indicating that the notification function is turned off. |
| Note: | Effective immediately. |



### AT+CIPEVENT
Function: Turn on or off event message notification prefixed with + CIPEVENT.

|Query command : |`AT+CIPEVENT?`|
|:---|:---|
| Response: | `+CIPEVENT=<state>`|
||`OK`|
| Parameter: | Refer to Setting command  Parameters|

| Setting command: |`AT+CIPEVENT=<state>`|
|:---|:---|
| Response: |`OK`|
| Parameter: | `state`: `ON`, which means that CIPEVENT notification function is turned on and `OFF`, which means that CIPEVENT notification function is turned off. 
| Note: | Effective immediately. Note: Users must first turn off the event notification function if they adopt the "pass-through mode of work". |


### AT+STANDBY
Function: To enter the module sleep mode, the STANDBY pin is needed to wake up. You can refer to the data manual pin definition content of the corresponding model module.

| Query command : |`AT+STANDBY`|
|:---|:---|
| Response: |`OK`|
| Parameter: | None|
| Note: | Effective immediately. The STANDBY pin must be used to wake up in order to respond to AT command. 




## 2. UART Management command

|Serial Number | Command | Description|
|:---:|:---|:--- |
| 1 | [AT + UART](#atuart) | Query / Set UART Serial Port Parameters|
| 2 | [AT + UARTFOMAT](#atuartfomat) | Query / Set the length and time of UART automatic trigger|
| 3 | [AT + UARTE](#atuarte) | Query / Set UART Serial Port Echo Status|


### AT+UART

Function: Query/set serial port parameters.

|Query command : |`AT+UART?`|
|:---|:---|
| Response: | `UART:<baud_rate>, <data_bits>, <stop_bit>, <parity>, <flow_control>]`|
||`OK`|
| Parameter: | Refer to Setting command  Parameters|


| Setting command: |`AT+UART=<baud_rate>, <data_bits>, <stop_bit>, <parity>, <flow_control>`|
|:---|:---|
| Response: |`OK`|
| Parameters: | `band_rate': baud rate, can be: 4800, 9600, 14400, 19200, 38400, 57600, 115200, 230400, 460800, 921600 bps|
||` Data_bits': Data bits, which can be: 7,8|
||` stop_bit `: stop bit, can be: 1, 2|
||` parity`: check bits can be: NONE: no check; ODD: odd check; EVEN: even check|
||` Flow_control': Flow control, can be: NONE: no flow control; CTS: enabling CTS flow control; RCS: enabling RTS flow control; CTSRTS: enabling CTSRTS flow control|
| Note: | Restart takes effect|


### AT+UARTFOMAT
Functions: Query/Set the trigger length and time of automatic framing (Wi-Fi/BT support)


| Query command : |`AT+UARTFOMAT?`|
|:---|:---|
| Response: | `+UARTFOMAT:<length>, <time>`|
||` OK`|
| Parameter: | Refer to Setting command  Parameters|


| Setting command: |`AT+UARTFOMAT=<length>, <time>`|
|:---|:---|
| Response: |`OK`|
| Parameter: | `length': automatic frame trigger length, unit: Byte, range: 1-1024, default: 1024. |
||` time `: automatic frame triggering time, unit: ms, range: 50-500, default: 100.|
| Description: | In command control mode, the minimum trigger length of automatic framing is 65, which takes effect immediately. |



### AT+UARTE
Function: Query/set whether the serial command turn on the echo function.

| Query command : |`AT+UARTE?`|
|:---|:---|
| Response: |`+UARTE:<option>`|
||`OK`|
| Parameter: | Refer to Setting command  Parameters|

| Setting command: |`AT+UARTE=<option>`|
|:---|:---|
| Response: |`OK`|
| Parameter: | `option`: ON, which means to turn on echo function and OFF, which means to turn off echo function. |
| Note: | Effective immediately. |


## 3. WiFi Management command

| Serial number | Command | Description|
|:---:|:---|:--- |
| 1 | [AT+WFVER](#atwfver) | Query RF firmware version number|
| 2 | [AT+WMAC](#atwmac) | Query MAC address|
| 3 | [AT + WSCANOPT](#atwscanopt) | Query / Set WiFi Scan Type|
| 4 | [AT + WSCAN](#atwscan) | Start WiFi scanning|
| 5 | [AT + WDHCP](#atwdhcp) | Query / Set whether DHCP is enabled|
| 6 | [AT + WSAPIP](#atwsapip) | Query / Set IP Address, Subnet Mask and Gateway in Soft_AP Mode|
| 7 | [AT + WSAP](#atwsap) | Query / Set the name and password of Soft_AP mode, and start AP|
| 8 | [AT + WSAPQ](#atwsapq) | Close AP|
| 9 | [AT + WSAPS](#atwsaps) | Query the current AP status|
| 10 | [AT + WJAPIP](#atwjapip) | Query / Set the IP address, subnet mask and gateway in Station mode|
| 11 | [AT + WJAP](#atwjap) | Query / Set the AP name and password for Station mode and connect to AP|
| 12 | [AT + WJAPQ](#atwjapq) | Disconnect AP|
| 13 | [AT + WJAPS](#atwjaps) | Query the current Station connection status|


### AT+WFVER
Function: Query RF Driver Version

| Command: |`AT+WFVER`|
|:---|:---|
| Response: | `+WFVER: < fver >`|
||`OK`|
| Parameter: | `fver': RF firmware version|
| Note: | Effective immediately. |


### AT+WMAC
Function: Query module MAC address

| Command: |`AT+WMAC`|
|:---|:---|
| Response: | `+WMAC:<mac>`|
||`OK`|
| PARAMETER: |`mac`: MAC address of module|
| Description: | `MAC` Address Format: XX: XX: XX: XX: XX: XX: XX: XX: XX. Effective immediately. |


### AT+WSCANOPT
Function: Query/Set WiFi Scan Type

| Query command: |`AT+WSCANOPTr`|
|:---|:---|
| Response: | `+WSCANOPT: < option >`|
||`OK`|
| Parameter: | Refer to command  Parameter Settings|


| Setting command: |`AT+WSCANOPT=<option>`|
|:---|:---|
| Response: |`OK`|
| Parameters: | `option`: 0, normal, normal scan; 1, advanced, advanced scan. |
| Explanation: | Normal scanning results only include SSID and signal strength, while advanced scanning results include ssid, bssid, encryption mode, channel and signal strength. Effective immediately. |


### AT+WSCAN
Function: Scan specified SSID or all AP

| Scanning command for AP specifying ssid: |`AT+WSCAN=<ssid>`|
|:---|:---|
| Response: | If the scan type is a normal scan, i.e. option = 0, return: `+WSCAN:<number>\r\n<ssid>, <rssi>.`|
|| If the scan type is advanced scan, i.e. option = 1, return: `+WSCAN:<number>\rn<ssid>, <bssid>, <en>, <channe>, <rssi>.`|
| Parameter: | Refer to scanning all AP command  parameters.|


| Scan all AP command: |`AT + WSCAN`|
|:---|:---|
| Response: | `+WSCAN: < number >`|
||`< SSID >, [bssid], [en], [channe], < RSSI >`|
| Parameter: | `number': Number of AP scanned. The parameters are printed in both conventional and advanced scans.|
| |`ssid`: The ssid of the scanned AP. Both normal and advanced scans print this parameter|
| |`bssid`: The bssid of the scanned AP. This parameter is printed when an advanced scan. |
| |`en`: The encryption method of the scanned AP. This parameter is printed when an advanced scan. |
| |`channel`: The channel of the scanned AP. This parameter is printed when an advanced scan. |
| |`rssi`: Signal strength of scanned APs |
|Description | Take effect immediately. |


### AT+WDHCP
Function: Query / Settings Whether to enable DHCP function

|Query command:|`AT+WDHCP?`|
|:--- |:---|
|Response:|`+WDHCP:<option>`|
|Parameter:|Please refer to setting command  parameters|

|Setting command:|`AT+WDHCP=<option>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`option`:`ON`, which means to start the DHCP function; `OFF`, which means to disable the DHCP function|
|Description:|Immediately effective|



### AT+WSPIP
Function: Query / set the IP address of the module in Soft_AP mode

|Query command:|`AT+WSAPIP?`|
|:--- |:---|
|Response:|`+WSAPIP:<ip>,<netmask>,<gateway>`|
|Parameter:|Please refer to setting command  parameters|


|Setting command:|`AT+WSAPIP=<ip>[,<netmask>,<gateway>]`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`ip`: IP address of Soft_AP|
| |`netmask`: Subnet Mask|
| |`gateway`: Gateway Address|
| Description:| Effective immediately. The factory default parameters of the module are 0. |


### AT+WSAP
Function: Query/set the name and password of Soft_AP and start it.

|Query command:|`AT+WSAP=?`|
|:--- |:---|
|Response:|`+WSAP:<ssid>,<key>`|
|Parameter:|Please refer to setting command  parameters|


|Setting command:|`AT+WSAP=<ssid>,<key>`|
|:---|:---|
|Response:|`OK`|
|Parameter: |ssid`: The ssid name of `Soft_AP`, up to 32 bits. |
| |`key`: The password for `Soft_AP`, up to 64 bits. When the length is less than 8 digits, the encryption method is: `OPEN`. When it is greater than 8 digits, the encryption method is: `WPA`. |
| Description:| Effective immediately. The module factory parameters default to 0. |

### AT+WSAPQ
Function: Turn off the current Soft_AP mode.

|Direction:|`AT+WSAPQ`|
|:--- |:---|
|Response:|`OK`|
|Parameter:|None|
| Description:| Effective immediately. |


### AT+WSAPS
Function: View the startup status of the current Soft_AP.

|Direction:|`AT+WSAPS`|
|:--- |:---|
|Response:|`+WSAPS:<state>`|
|Parameter:|`state`:`AP_UP`, indicating that `Soft_AP`; `AP_DOWN` was successfully created, indicating that `Soft_AP` is closed. |
| Description:| Effective immediately. |


### AT+WJAPIP
Function: Query/set the IP address of the module in Station mode.

|Query command:|`AT+WJAPIP?`|
|:--- |:---|
|Response:|`+WJAPIP:<ip>,<network>,<gateway>,<dns>`|
|Parameter:|Please refer to setting command  parameters|


|Setting command:|`AT+WJAPIP=<ip>,<network>,<gateway>[,<dns>]`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`ip`: IP address of the module when doing station |
| |`network`: Subnet Mask |
| |`gateway`: Gateway Address |
| |`dns`: Domain Name|
|Description:|The module restart takes effect. When the module is not successfully connected to the AP, each parameter defaults to 0. |


### AT+WJAP

Function: Query the name and password of the AP to be accessed in Station mode.

|Query command:|`AT+WJAP=?`|
|:--- |:---|
|Response:|`+WJAP:<ssid>,<key>`|
|Parameter:|`ssid`: AP name to be accessed in Station mode|
| |`key`: AP password to be accessed in Station mode |


Function: Query the current WiFi connection status, including: SSID, MAC address, channel number, and signal strength of the AP that is connected.

|Query command:|`AT+WJAP?`|
|:--- |:---|
|Response:|`+WJAP:<ssid>,<bssid>,<channel>,<rssi>`|
|Parameter:|`ssid`: ssid| of connected APs|
| |`bssid`: MAC address of the connected AP |
| |`channel`: channel number of the connected AP |
| |`rssi`: Signal strength of connected APs |
|Description | When the module is not successfully connected to the AP, each parameter defaults to 0. |

Function: Set the name and password of the AP to be accessed in Station mode.

|Setting command:|`AT+WJAP=<ssid>,<key>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`ssid`: AP name to be accessed in Station mode|
| |`key`: AP password to be accessed in Station mode |
| Description:| Effective immediately. |


### AT+WJAPQ
Function: Turn off the current Station mode

|Command:|`AT+WJAPQ`|
|:--- |:---|
|Response:|`OK`|
|Parameter:|None|
| Description:| Effective immediately. |


### AT+WJAPS
Function: View the connection status of the current Station mode

|Command:|`AT+WJAPS`|
|:--- |:---|
|Response:|`+WJAPS:<state>`|
|Parameter:|`state`:`STATION_UP`, indicating successful connection to AP; `STATION_DOWN`, indicating that the connection AP failed; `CONNECTING`, indicating that it is connecting. |
| |NOTE: An error code is returned when the connection is not successful. 0: represents an unknown error; 1: represents a password error; 2: represents the SSID not found |
| Description:| Effective immediately. |

## 4.TCP and UDP communication command

|Order|Director|Function|
|:---:|:---|:---|
|1 |[AT+SSLCERTGET](#atsslcertget)|Get SSL Certificate|
|2 |[AT+SSLCERTSET](#atsslcertset)|Set SSL Certificate|
|3 |[AT+CIPDOMAIN](#atcipdomain)|Domain Analysis|
|4 |[AT+CIPAUTOCONN](#atcipautoconn)|Query/Setup Specify whether id connection is automatic connection|
|5 |[AT+CIPSSLOPT](#atcipsslopt)|Set the ssl parameter of the specified id connection|
|6 |[AT+CIPSTART](#atcipstart)|Start a connection with the specified id|
|7 |[AT+CIPSTOP](#atcipstop)|Disconnect a specified id |
|8 |[AT+CIPSTATUS](#atcipstatus)|Query the connection status of the specified id|
|9 |[AT+CIPSEND](#atcipsend)|Send data to the specified id connection via the serial port|
|10 |[AT+CIPSENDRAW](#atcipsendraw)|Command mode jumps to transparent mode|
|11 |[AT+CIPRECV](#atciprecv)|Receive WiFi data to user serial port|
|12 |[AT+CIPRECVCFG](#atciprecvcfg)|Query/Setup WiFi data is sent to the user serial port, through command mode, or transparent mode |


### AT+SSLCERTGET
Function: Get the SSL certificate type.


|Command:|`AT+SSLCERTGET=<type>`|
|:---|:---|
|Response:|`+SSLCERTGET:cert`|
| | `OK` |
|Parameter:|`type`:0, for the root certificate; 1, for the client certificate; 2, for the private key; 3, for the certificate revocation list |
| Description:| Effective immediately. |


### AT+SSLCERTSET
Function: Set the SSL certificate type.


|Command:|`AT+SSLCERTSET=<type>`|
|:---|:---|
|Response:|`>`|
|Parameter:|`type`:0, for the root certificate; 1, for the client certificate; 2, for the private key; 3, for the certificate revocation list |
| Description:| Effective immediately. After returning `>`, pass the certificate file and append `Ctrl+Z` (ASCII code is `0x1A`, which is not part of the certificate) at the end of the certificate, as the certificate delivery terminator. |


### AT+CIPDOMAIN
Function: Domain name resolution.

|Command:|`AT+CIPDOMAIN=<domain>`|
|:--- |:---|
|Response:|`+CIPDOMAIN:<number>`|
| | `<ip>`|
|Parameter:|`number`:Number of IP addresses|
| |`ip`:IP address|
| Description:| Effective immediately. |


### AT+CIPAUTOCONN
Function: Query/Set the specified id connection is automatic connection.

|Query command:|`AT+CIPAUTOCONN=<id>`|
|:--- |:---|
|Response:|`+CIPAUTOCONN:<option>`|
| |`OK`|
|Parameter:|Please refer to setting command  parameters|


|Setting command:|`AT+CIPAUTOCONN=<id>,<option>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`id`: Specify the id number of the connection|
| |`option`: 0 means to turn off automatic connection; 1, to open automatic connection. |
| Description:| Effective immediately. The factory default is 1. |


###AT+CIPSSLOPT
Function: Set the SSL parameters of the specified id connection.

|Setting command:|`AT+CIPSSLOPT=<id>,<isSSLRoot>,<isSSLClient>[,isSSLCrl]`|
|:--- |:---|
|Response:|`OK`|
|Parameter:|`id`: Specify the id number of the connection|
| |`isSSLRoot`:0, do not verify the root certificate; 1, verify the root certificate |
| |`isSSLClient`:0, does not verify the client certificate; 1, verify the client certificate|
| |`isSSLCrl`:0, do not verify the certificate revocation list; 1, verify the certificate revocation list|


### AT+CIPSTART
Function: start a connection

|Command:|`AT+CIPSTART=<id>,<type>,[domain],[remote_port],[local_port]`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`id`: Specify the id number of the connection, the range: 0 - 4, that is, up to 5 connections can be created. |
| |`tpye`: Connection type, including: `tcp_server`, `tcp_client`, `ssl_client`, `udp_broadcast`, `udp_unicast`. They are as follows: |
| |--- 1. When `type` is `tcp_server`, the parameters are: `id, tcp_server, local_port`;|
| |--- 2. When `type` is `tcp_client`, the parameters are: `id, tcp_client, domain, remote_port[,local_port]`;|
| |--- 3. When `type` is `ssl_client`, the parameters are: `id, ssl_client, domain, remote_port[,local_port]`;|
| |--- 4. When `type` is `udp_broadcast`, the parameters are: `id, udp_broadcast, domain, remote_port, local_port`;|
| |--- 5. When `type` is `udp_unicast`, the parameters are: `id, udp_unicast, domain, remote_port, local_port`. |
| |`domain`: The IP or domain name of the target server. This parameter is not required when type is tcp_server. |
| |`remote_port`: Remote port. |
| |`local_port`: Local port. When type is tcp_client or ssl_client, this parameter is the specified local port|
| Description:| Effective immediately. Note: If the current id connection is not closed, it will not be executed successfully when it is set and connected again. It returns: ERROR. Before changing the parameters of any id, you must manually close it, that is, execute the command: `AT+CIPSTOP=id\r` to set and connect correctly. |


### AT+CIPSTOP
Function: Disconnect a connection with the specified id.

|Command:|`AT+CIPSTOP=<id>[,<remote_port>]`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`id`: Specify the id number of the connection. |
| Description:| Effective immediately. |


### AT+CIPSTATUS
Function: Query the connection status of the specified id.

|Command:|`AT+CIPSTATUS=<id>`|
|:---|:---|
|Response:|`+CIPSTATUS:<type>,<status>`|
|Parameter:|`type`: Specifies the connection type of id, including: tcp_server, tcp_client, udp_broadcast, udp_unicast, ssl_client. |
| |`status`:start, initialize;connecting,connecting;connected,connected;disconnected,disconnected;stop,stop connection|
| Description:| Effective immediately. |



### AT+CIPSEND
Function: Send WiFi data to the user serial port.

|Command: |`AT+CIPSEND=<id>[,<remote_port>],<data_length>\r<data>`|
|:---|:---|
|Response:|`+OK`|
|Parameter:|`id`: Specify the connection for id. |
| |`remote_port`: The remote port number of the connection. You only need to specify the remote port number when the module is doing tcp server. Other socket types do not need to be specified. |
| |`data_length`: Data length. Unit: byte byte. |
| |`data`: Data content. |
| Description:| Effective immediately. |
|Example:|AT+CIPSEND=0,54590,9\r123456789 |
| |AT+CIPSEND=1,9\r123456789 |


### AT+CIPSENDRAW
Function: Jump from AT command mode to transparent mode.

|Command:|`AT+CIPSENDRAW`|
|:---|:---|
|Response:|`OK`|
|Parameter:|None|
| Description:| Effective immediately. |


### AT+CIPRECV
Function: Receive WiFi data to the user serial port.

|Command:|`AT+CIPRECV=<id>,<port>,<len>`|
|:---|:---|
|Response:|`+CIPRECV=<len>,<data>`|
| |`OK`|
|Parameter:|`id`: Specify the connection of the id number|
| |`port`: Specify the remote port number of the connection |
| |`len`: Specified data reception length, unit: byte bytes |
| |`data`: Data|
| Description:| Effective immediately. |


### AT+CIPRECVCFG
Function: Query/set the configuration parameters of the WiFi data sent to the user serial port.

|Query command:|`AT+CIPRECVCFG?`|
|:---|:---|
|Response:|`+CIPRECVCFG:<recv mode>`|
| | `OK` |
|Parameter:|Please refer to the setting command parameters. |
| Description:| Effective immediately. |

|Setting command:|`AT+CIPRECVCFG=<recv mode>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`recv mode`:0, which means that the cmd command mode needs to be received by the command  `AT+CIPRECV`; 1, which means the raw transparent transmission mode, indicating automatic reception. |
| Description:| Effective immediately. |




## 5.MQTT communication command 

|Order |Order |Function |
|:---:|:--- |:--- |
|1 |[AT+MQTTAUTH](#atmqttauth) |Query/Set MQTT User Authorization Information|
|2 |[AT+MQTTSOCK](#atmqttsock) | Query/Set MQTT socket information |
|3 |[AT+MQTTCAVERIFY](#atmqttcaverify)|Query/Set MQTT Certificate Authentication Enable Status|
|4 |[AT+MQTTSSL](#atmqttssl) |Query/Set MQTT SSL Enable Status|
|5 |[AT+MQTTCID](#atmqttcid) | Query/Set MQTT Client Identifier|
|6 |[AT+MQTTKEEPALIVE](#atmqttkeepalive)|Query/Set MQTT Heartbeat Cycle|
|7 |[AT+MQTTRECONN](#atmqttreconn)|Query/Set MQTT Auto Reconnect Enable Status|
|8 |[AT+MQTTAUTOSTART](#atmqttautostart)|Query/Set MQTT Power-on Automatic Connection Enable Status|
|9 |[AT+MQTTEVENT](#atmqttevent)|Query/Set MQTT Event Push Enable Status|
|10 |[AT+MQTTSTART](#atmqttstart)|Start MQTT Service|
|11 |[AT+MQTTSUB](#atmqttsub)|Query/Set MQTT Subscription Information|
|12 |[AT+MQTTPUB](#atmqttpub)|Query/Set MQTT Release Information|
|13 |[AT+MQTTSEND](#atmqttsend)|MQTT Release Data|
|14 |[AT+MQTTUNSUB](#atmqttunsub)|MQTT Unsubscribe|
|15 |[AT+MQTTSTATUS](#atmqttstatus)|Query MQTT Status|
|16 |[AT+MQTTCLOSE](#atmqttclose)|Close MQTT Service|


### AT+MQTTAUTH
Function: Query/set MQTT user authorization information.

|Query command:|`AT+MQTTAUTH=?`|
|:---|:---|
|Response:|`+MQTTAUTH:<UserName>,<PassWord>`|
| | `OK` |
|Parameter:|Please refer to the setting command parameters. |
| Description:| Effective immediately. |

|Settings:|`AT+MQTTAUTH=<UserName>,<PassWord>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`UserName`: Username|
| |`PassWord`: Password|
| Description:| Effective immediately. |


### AT+MQTTSOCK
Function: Query/set MQTT socket information.

|Query command:|`AT+MQTTSOCK=?`|
|:---|:---|
|Response:|`+MQTTSOCK:<Host>,<Port>`|
| | `OK` |
|Parameter:|Please refer to the setting command parameters. |
| Description:| Effective immediately. |

|Setting command:|`AT+MQTTSOCK=<Host>,<Port>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`Host`: Remote URL|
| |`Port`: Remote Port|
| Description:| Effective immediately. |


### AT+MQTTCAVERIFY
Function: Query/set the MQTT certificate authentication enable status.

|Query command:|`AT+MQTTCAVERIFY=?`|
|:---|:---|
|Response:|`+MQTTCAVERIFY:<Status1>,<Status2>`|
| | `OK` |
|Parameter:|Please refer to the setting command parameters. |
| Description:| Effective immediately. |

|Setting command:|`AT+MQTTCAVERIFY=<Status1>,<Status2>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`Status1`: Whether to enable server root certificate verification, `ON`: enable, `OFF`: off. |
| |`Status2`: Whether to enable verification of client certificate verification, `ON`: enable, `OFF`: off. |
| Description:| Effective immediately. |


### AT+MQTTSSL
Function: Query/set the MQTT SSL enable status.

|Query command:|`AT+MQTTSSL=?`|
|:---|:---|
|Response:|`+MQTTSSL:<Status>`|
| | `OK` |
|Parameter:|Please refer to the setting command parameters. |
| Description:| Effective immediately. |

|Settings:|`AT+MQTTSSL=<Status>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`Status`: Whether to enable `SSL` encryption, `ON`: enable, `OFF`: off. |
| Description:| Effective immediately. |



### AT+MQTTCID

Function: Query/set the MQTT client identifier.

|Query command:|`AT+MQTTCID=?`|
|:---|:---|
|Response:|`+MQTTCID:<ClientID>`|
| | `OK` |
|Parameter:|Please refer to the setting command parameters. |
| Description:| Effective immediately. |

|Setting command:|`AT+MQTTCID=<ClientID>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`ClientID`: Client identifier. |
| Description:| Effective immediately. |

### AT+MQTTKEEPALIVE
Function: Query/set the MQTT heartbeat cycle.

|Query command:|`AT+MQTTKEEPALIVE=?`|
|:---|:---|
|Response:|`+MQTTKEEPALIVE:<Period>`|
| | `OK` |
|Parameter:|Please refer to the setting command parameters. |
| Description:| Effective immediately. |

|Setting command:|`AT+MQTTKEEPALIVE=<Period>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`Period`: Heartbeat period, unit: s (seconds). |
| Description:| Effective immediately. |

### AT+MQTTRECONN
Function: Query/set the MQTT automatic reconnection enable status.

|Query command:|`AT+MQTTRECONN=?`|
|:---|:---|
|Response:|`+MQTTRECONN:<Status>`|
| | `OK` |
|Parameter:|Please refer to the setting command parameters. |
| Description:| Effective immediately. |

|Setting command:|`AT+MQTTRECONN=<Status>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`Status`: Whether to enable automatic reconnection. `ON`: Enable, `OFF`: Off. |
| Description:| Effective immediately. |


### AT+MQTTAUTOSTART
Function: Query/set the MQTT power-on automatic connection enable status.

|Query command:|`AT+MQTTAUTOSTART=?`|
|:---|:---|
|Response:|`+MQTTAUTOSTART:<Status>`|
| | `OK` |
|Parameter:|Please refer to the setting command parameters. |
| Description:| Effective immediately. |

|Setting command:|`AT+MQTTAUTOSTART=<Status>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`Status`: Whether to enable automatic connection at power-on, `ON`: enable, `OFF`: off. |
| Description:| Effective immediately. |


### AT+MQTTEVENT
Function: Query/set the MQTT event push enable status.

|Query command:|`AT+MQTTEVENT=?`|
|:---|:---|
|Response:|`+MQTTEVENT:<Status>`|
| | `OK` |
|Parameter:|Please refer to the setting command parameters. |
| Description:| Effective immediately. |


|Setting command:|`AT+MQTTEVENT=<Status>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`Status`: Whether event push is enabled. `ON` is enabled; `OFF` is off. |
| Description:| Effective immediately. After this function is enabled, all MQTT events will be actively output through the serial port. The format is as follows: `+MQTTEVENT:<result>`. |
The ||`result` parameter description is described in the [AT+MQTTSTATUS](#atmqttstatus) command . |


### AT+MQTTSTART
Function: Start the MQTT service.

|Execution command:|`AT+MQTTSTART`|
|:---|:---|
|Response:|`OK` |
|Parameter:|None|
| Description:| Effective immediately. |

### AT+MQTTSUB
Function: Query/set MQTT subscription information.

|Query command:|`AT+MQTTSUB=?`|
|:---|:---|
|Response:|`+MQTTSUB:<sub_num>`|
| |`<id_0>,<Topic_0>,<QoS_0>`|
| |...|
| |`<id_n>,<Topic_n>,<QoS_n>`|
| | `OK`|
|Parameter:|`sub_num`: The number of topics to be queried, up to 6|
| |The rest of the parameters refer to the setup command. |
| Description:| Effective immediately. |


|Setting command:|`AT+MQTTSUB=<id>,<Topic>,<QoS>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`id`: The id number assigned to each topic, ranging from 0-5. |
| |`Topic`: The subject of the subscription. |
| |`QoS`: QoS of the subscription topic, ranging from 0-2. |
| Description:| Effective immediately. |




### AT+MQTTPUB
Function: Query/set MQTT release information.

|Query command:|`AT+MQTTPUB=?`|
|:---|:---|
|Response:|`+MQTTPUB:<Topic>,<QoS>`|
| | `OK` |
|Parameter:|Please refer to the setting command parameters. |
| Description:| Effective immediately. |

|Setting command:|`AT+MQTTPUB=<Topic>,<QoS>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`Topic`: The subject of the post. |
| |`QoS`: QoS for issuing information, range: 0-2. |
| Description:| Effective immediately. This topic is only used to set topic and QoS, and use the `AT+MQTTSEND=<len>` Command to publish data. Before publishing data to different Topic, you need to call the `AT+MQTTPUB=<Topic>, <QoS>` command to replace the corresponding Topic and QoS. |


### AT+MQTTSEND
Function: MQTT release data

|Execution command:|`AT+MQTTSEND=<len>`|
|:---|:---|
|Response:|`>`|
|Parameter: |`len`: The length in bytes of the published data. |
| Description:| Effective immediately. After receiving >, you need to send the specified length of data to the module, and the module will release the data to the remote end. |



### AT+MATTUNSUB
Function: MQTT unsubscribe

|Execution command:|`AT+MQTTUNSUB=<id>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`id`: Unsubscribe the id number corresponding to the topic |
| Description:| Effective immediately. |


### AT+MQTTSTATUS
Function: Query the MQTT status.

|Query command:|`AT+MQTTSTATUS=<action>[,id>]`|
|:---|:---|
|Response:|`+MQTTSTATUS:<result>`|
| |`OK`|
|Parameter:|`action`: The behavior of the client relative to the remote, including three categories: `connect`, `subscribe`, `publish`. |
| |`id`: optional parameter, when the value of `action` is `subscribe`, you need to specify the id number|
| |`result`: The status result returned. According to different `action` values, a total of the following different results are included |
| |1. When the value of `action` is `connect`, return: |
| |`—— CONNECT, SUCCESS` connection success|
| |`—— CONNECT,INIT_ERROR` Initialization error|
| |`—— CONNECT, FAIL` connection failed |
| |`—— CONNECT,RECONNECTING` Connecting |
| |`—— CLOSE, SUCCESS` Closed successfully |
| |`—— CLOSE,FAIL` Shutdown failed|
| |2. When the value of `action` is `subscribe`, return: |
| |`—— SUBSCRIBE, SUCCESS` Subscribed successfully|
| |`—— SUBSCRIBE, FAIL` Subscription failed |
| |`—— UNSUBSCRIBE, SUCCESS` Unsubscribe successfully |
| |`—— UNSUBSCRIBE,FAIL` Unsubscribe failed |
| |3. When the value of `action` is `publish`, return: |
| |`—— PUBLISH, SUCCESS` Released successfully|
| |`—— PUBLISH,FAIL` Release failed|
| Description:| Effective immediately. |

### AT+MQTTCLOSE
Function: Turn off the MQTT service

|Execution command:|`AT+MQTTCLOSE`|
|:---|:---|
|Response:| `OK` |
|Parameter:|None|
|Description:|Immediate immediately|



## 6.Distribution network instructions

|Number|Command|
|:---|:---|
|1 |[AT+SMARTSTART](#atsmartstart)|Set the distribution method and start|
|2 |[AT+SMARTSTOP](#atsmartstop) |Disconnected distribution method |

### AT+SMARTSTART
Function: Set the distribution mode: Easylink or Airkiss, and start the distribution network.

|Execution command:|`AT+SMARTSTART=<type>`|
|:---|:---|
|Response:| `OK` |
|Parameter:|`type`: integer type. |
| |1:[Easylink distribution network](docs/easylink/easylink_index.md)|
| |2: Airkiss distribution network; |
| |3: Easylink AWS distribution network. |
| |4: Easylink+Airkiss fusion distribution network;|
| |5: SoftAP distribution network (only supports [IOS latest version of Easylink APP] (docs/easylink/page/easylink_ios.md)). |
| Description:| Effective immediately. |

### AT+SMARTSTOP
Function: Stop the set distribution mode.

|Execution command:|`AT+SMARTSTOP=<type>`|
|:---|:---|
|Response:| `OK` |
|Parameter:|`type`: 1: means Easylink distribution network; 2: means Airkiss distribution network; 3: means Easylink AWS distribution network. |
| Description:| Effective immediately. Note: Parameter 3: Easylink AWS Distribution Network, this command does not work with AlinkV3 Ali Direct AT firmware. |

### AT+SMARTCFG
Function: Set the Airkiss distribution parameters.

|Setting command: |`AT+SMARTCFG=<device_id>,<original_id>`|
|:---|:---|
|Response:| `OK` |
|Parameter:|`device_id`: String, provided by the background when WeChat is registered. |
| |`original_id`: String, provided by the background when WeChat is registered. |
| Description:| Effective immediately. |



## 7.SNTP time synchronization command 
### AT+SNTPCFG
Function: Set the NTP domain name.

|Setting command:|`AT+SNTPCFG=<time_zone>[,<domain1>[,<domian2>]]`|
|:---|:---|
|Response:| `OK` |
|Parameter:|`time_zone`: Time zone, such as Beijing: +8|
| |`domain1`: NTP server domain 1|
| |`domian2`: NTP server domain 2|
| Description:| Effective immediately. |


### AT+SNTPTIME
Function: Get NTP time.

|Execution command:|`AT+SNTPTIME`|
|:---|:---|
|Response:| `+SNTPTIME:<time>` |
| | `OK` |
|Parameter:|`time`: The shape is like `2017-09-05T13:34:35.063568`, indicating: The current SNTP time is September 5, 2017 13 : 34 : 35, 63568 microseconds. |
| Description:| Effective immediately. |

### AT+RTCGET
Function: Get NTP time.

|Execution command:|`AT+RTCGET`|
|:---|:---|
|Response:| `+RTCGET:<time>` |
| |`OK` |
|Parameter:|`time`: The shape is like `2017-09-05T13:34:35.063568`, indicating: The current RTC time is September 5, 2017 13 : 34 : 35, 63,568 microseconds. |
| Description:| Effective immediately. |



## 8.BT control command 

The BT Control Command only supports the Wi-Fi/BT module: EMW3239.

This section describes all AT commands that implement the Bluetooth communication and transparent transmission functions of the BT module.

|Order |Order |Function |
|:---:|:--- |:--- |
|1 |[AT+BTNAME](#atbtname) | Query/Set Classic Bluetooth Device Name|
|2 |[AT+BTPASSKEY](#atbtpasskey) | Query/Set Classic Bluetooth Pairing Key |
|3 |[AT+BTMAC](#atbtmac) |Query Classic Bluetooth Device Address|
|4 |[AT+BTDISCOVERY](#atbtdiscovery)|Turn on/off Bluetooth to discover connectable mode|
|5 |[AT+BTEVENT](#atbtevent) | Query/Set Monitor Bluetooth Events |
|6 |[AT+BTSTATE](#atbtstate) | Query Bluetooth Status|
|7 |[AT+BTSEND](#atbtsend) |Send specified length data|
|8 |[AT+BTSENDRAW](#atbtsendraw) |Enter transparent mode|

### AT+BTNAME
Function: Query/Set Classic Bluetooth device name (the device name displayed when BT is in discoverable mode).

|Query command:|`AT+BTNAME=?`|
|:--- |:---|
|Response:|`+BTNAME:<name>`|
|Parameter:|Please refer to setting command  parameters|


|Setting command:|`AT+BTNAME=<name>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`name`: Device name when BT is in discoverable mode|
| Description:| Effective immediately. |

### AT+BTPASSKEY
Function: Query / Set Classic Bluetooth device pairing key

|Query command:|`AT+BTPASSKEY=?`|
|:--- |:---|
|Response:|`+BTPASSKEY:<passkey>`|
|Parameter:|Please refer to setting command  parameters|

|Execution command:|`AT+BTPASSKEY=<passkey>`|
|:---|:---|
|Response:|`OK`|
|Parameter:|`passkey`: BT device pairing key (must be 6 digits)|
|Description:|Immediately effective|

### AT+BTMAC
Function: Query classic Bluetooth device address

|Query command:|`AT+BTMAC=?`|
|:--- |:--- |
|Response:|`+BTMAC:<mac>`|
|Parameter:| `mac`: MAC address of the device, in the format `xx:xx:xx:xx:xx:xx`|
|Description:|Bluetooth address does not support setting|

### AT+BTDISCOVERY
Function: On/Off Classic Bluetooth can discover connectable mode

|Execution command:|`AT+BTDISCOVERY=<ON/OFF>`|
|:--- |:--- |
|Response:|`OK`|
|Parameter:|`<ON>`: Device enters to discover connectable mode|
| |`<OFF>`: The device cannot be found and cannot be connected |
|Description:|Immediately effective|
| | Enter transparent mode to automatically open to discover connectable mode|


### AT+BTEVENT
Function: Set/Query Whether to monitor Bluetooth events (connection establishment, connection disconnection, etc.)

|Query command:|`AT+BTEVENT?`|
|:---|:---|
|Response:|`+BTEVENT:<EN/DN>`|
|Parameter:|Please refer to setting command  parameters|


|Setting command: |`AT+BTEVENT=<EN/DN>`
|:---|:---|
|Parameter:|`EN`: Enable listening to Bluetooth events|
| |`DN`: Disable listening for Bluetooth events |
|Response:|`OK`|
|Description:|Immediately effective, default enabled|
| | When in the command mode and enable the listen event, the received transparent data will be sent to the serial port with the `+BTEVENT:DATA` event. |
| | If the listen event is disabled, the received data is directly transmitted to the serial port. (Please read the corresponding event type for details)|



### AT+BTSTATE
Function: Query the current working status of Bluetooth
Note: Bluetooth working status is: `Connected`, `Disconnected`, `Discoverable` three states.

|Query command:|`AT+BTSTATE?`|
|:---|:---|
|Response:|`+BTSTATE:<CONNECTED/DISCONNECTED/DISCOVERABLE>`|
|Parameter:|`CONNECTED`: RFCOMM connection has been established |
| |`DISCONNECTED`: RFCOMM connection does not exist or has been disconnected |
| |`DISCOVERABLE`: BT device is in discoverable mode|


### AT+BTSEND
Function: Send data in command mode

|Execution command:|`AT+BTSEND=<length>`|
|:---|:---|
|Response:|`>`|
|Parameter:|`length`: the length of the data to be sent |
|Description:|When the user receives the `>` response, the specified length of data should be sent directly through the serial port. The Bluetooth device will receive and pass the data to the connected Bluetooth host |
|Note: |The device internally waits for user data within the specified time after returning the `>` response. If it has timed out, the device will only send data that has already been received. The timeout period is generally 6s. |

### AT+BTSENDRAW
Function: Enter BT transparent transmission mode

|Execution command:|`AT+BTSENDRAW`|
|:---|:---|
|Response:|`OK`|
|Description:|When the device enters the transparent transmission mode, if the RFCOMM connection is not established at this time, the device automatically enters the discoverable connectable mode. |
| |Exit mode, please enter `+++`|


## 9. Ethernet transparent transmission command

|Order |Order |Function|
|:---:|:--- |:---|
|1 |[AT+ENETRAWMODE](#atenetrawmode) |Settings/Query Ethernet Transparent Transmission Mode Status|
|2 |[AT+ENETRAWSEND](#atenetrawsend) |Send Ethernet Data|

### AT+ENETRAWMODE
Function: Set / Query Ethernet transparent transmission mode status

|Query command:|`AT+ENETRAWMODE?`|
|:--- |:---|
|Response:|`+ENETRAWMODE:<mode>`|
| |`OK`|
|Parameter:|Please refer to setting command  parameters|

|Setting command:|`AT+ENETRAWMODE=<mode>`|
|:--- |:---|
|Response:|`OK`|
|Parameter:|`mode`: ON: On; OFF: Off; TCP/IP related function will be invalid after starting Ethernet transparent transmission mode|
| Description:| Effective immediately. |

### AT+ENETRAWSEND
Function: Send Ethernet data

|Command:|`AT+ENETRAWSEND=<data_length>`|
|:---|:---|
|Response:|`>` Wait for the date data of the specified length to be entered, and the input is valid within 1 minute. |
|Parameter:|`data_length`: Data length. Unit: byte byte. |
| Description:| Effective immediately. |


## 10. Firmware OTA Command

Note: All models are available from ATv2.0.3. AT firmware supports online OTA function through AT command (Note: except for the firmware of Ali ilop platform, please refer to the specific documentation for OTA function implementation).

### AT+OTACHECK
Function: Query the cloud AT firmware version number.

|Query command:|`AT+OTACHECK`|
|---|:---|
|Response:|`+OTACHECK:<version>`|
| |`+OK`|
|Parameter:|`version`: The version number of all ota firmware in the cloud. The form is: fog_v3_AT_v2.0.4. |
|Description:|The module first needs to enable STATION mode and successfully connect to the AP to execute this command. |
|**Note**： |**AT2.x firmware, starting with v2.0.3, supports remote networking OTA functionality.** |


### AT+OTASTART
Function: Update the AT firmware with the specified version number.

|Update Command:|`AT+OTASTART=<version>`|
|:--- |:---|
|Response:|`+OK`|
| |`+OTAEVENT:START` indicates the start of the OTA process. |
| |`+OTAEVENT:SUCCESS` indicates that the OTA was successful. |
|Parameter:|`version`: The version number of all ota firmware in the cloud. The form is: fog_v3_AT_v2.0.4. |
|Description |Users can update the firmware of the specified version number as needed, and can be updated to a lower version or to a higher version. And the OTA process must ensure that the continuous networking is not broken, otherwise the update may fail. The process lasts for a few seconds to about 10 seconds. After the OTA is successful, the device automatically restarts. |




## EVENT event notification
Depending on the features, EVENT event notifications include:

 1. +WEVNET Start: Represents event messages related to the WiFi function.
 2. +CIPEVENT Start: Represents an event message related to the network connection function.
 3. +MQTTEVENT Start: Represents an event message related to MQTT communication.
 4. +BTEVENT Start: Represents event messages related to classic Bluetooth passthrough.
 5. +ENETEVENT Start: Represents the time message associated with the Ethernet function.
 6. +OTA Start: Represents an event message related to the OTA process.
 7. +ILOP Start: Represents an event message related to the ILOP connection status.
 8. +GOME Start: Represents an event message related to the GOME connection status.


|Serial |Event Message |Description |
|:---:  |:--- |:--- |
|**Class 1** |**WiFi notification** |**WiFi status** |
|1 |`+WEVENT:AP_UP ` |Soft_AP created successfully|
|2 |`+WEVENT:AP_DOWN ` |Soft_AP creation failed |
|3 |`+WEVENT:STATION_UP ` |STATION Connection success|
|4 |`+WEVENT:STATION_DOWN ` |STATION Connection failed |
|**Class 2** |**Network Notification** |**Network Connection Status** |
|1 |`+CIPEVENT: id, SERVER, CONNECTED` | successfully connected to the TCP server with the specified id link |
|2 |`+CIPEVENT:id,SERVER,DISCONNECTED` |Disconnected from TCP server with link number id |
|3 |`+CIPEVENT: id, SERVER, CLOSED` | Successfully stop the TCP server with the specified id link |
|4 |`+CIPEVENT: CLIENT, CONNECTED, ip, port`| TCP client successfully connected to the ip address and port port |
|5 |`+CIPEVENT:CLIENT,CLOSED,ip,port ` |Successfully stop the TCP client for the ip address and port port|
|6 |`+CIPEVENT: id, UDP, CONNECTED ` | UDP connection success |
|7 |`+CIPEVENT: id, UDP, CLOSED ` |UDP connection failed |
|8 |`+CIPEVENT:SOCKET,id,len,data` |Identifies network data sources|
|9 |`+CIPEVENT: UDP_BROADCAST, ip, port, id, len, data`| UDP broadcast data source and information, supported from ATv 2.0.3. |
|**Class 3**|**MQTT notification** |**MQTT communication status** |
|1 |`+MQTTEVENT: CONNECT, SUCCESS` | Successful connection to MQTT server|
|2 |`+MQTTEVENT: CONNECT,INIT_ERROR ` |Connection initialization error with MQTT server|
|3 |`+MQTTEVENT: CONNECT,FAIL ` |Failed to connect to MQTT server|
|4 |`+MQTTEVENT:CONNECT,RECONNECTING ` |Reconnect with MQTT server|
|5 |`+MQTTEVENT:CLOSE,SUCCESS` |MQTT communication closed successfully|
|6 |`+MQTTEVENT:CLOSE,FAIL` |MQTT communication shutdown failed |
|7 |`+MQTTEVENT:SUBSCRIBE,SUCCESS` |MQTT subscription success|
|8 |`+MQTTEVENT:SBUSCRIBE,FAIL ` |MQTT subscription failed|
|9 |`+MQTTEVENT: UNSUBSCRIBE,SUCCESS` |MQTT unsubscribe success|
|10 |`+MQTTEVENT: UNSUBSCRIBE,FAIL` |MQTT Unsubscribe failed |
|11 |`+MQTTEVENT:PUBLISH,SUCCESS ` |MQTT released successfully|
|12 |`+MQTTEVENT:PUBLISH,FAIL ` |MQTT release failed|
|**Class 4** |**BT Notification** |**BT Communication Status** |
|1 |`+BTEVENT:CONNECTION,ON` | Successful connection to RFCOMM remote host|
|2 |`+BTEVENT:CONNECTION,OFF` |Disconnected from RFCOMM remote host|
|3 |`+BTEVENT:DATA,length ` |Received data from RFCOMM remote host|
|**Class 5** | **Ethernet Transparent Notification** | **Ethernet Transparent Event** |
|1|`+ENETEVENT: len,data` |Identifies Ethernet transparent data|
|**Class 6** | **OTA notifications** | **OTA status** |
|1|`+OTAEVENT:START` |Start OTA firmware update process |
|2|`+OTAEVENT:SUCCESS` |OTA Firmware Update Successful |
|**Class 7**|**ILOP event notification**|**ILOP connection status**|
|1|`+ILOPEVENT=ILOP,TSL_THING`|When mode=2, the module requests the thing model|
|2|`+ILOPEVENT=ILOP,<status>`|Connect to server status. Status: CLOUD_CONNECT: server connection is successful; LOCAL_CONNECT: LAN control connection; CLOUD_DISCONNECT: server disconnection; CLOUD_DISCONNECT: LAN control disconnection |
|3|`+ILOPEVENT=SETICA,<method>,<key>,<value>`|Submit ICA standard data, parameters with AT+ILOPSENDICA command parameters|
|4|`+ILOPEVENT=SETRAW,<date_len>,<data>`|Imitate transparent/custom protocol data|
|**Class 8** | **GOME event notification** | **GOME connection status** |
|1|`+GOMEEVENT: GOME, CONNECTING` | Server Connection |
|2|`+GOMEEVENT: GOME, CONNECTED` | Server connection success |